# !/usr/bin/env python
# coding=utf-8
"""
Samples for ipv6gateway client.
"""
import uuid

from baidubce import exception
from baidubce.services.ipv6gateway.ipv6gateway_client import IPv6GatewayClient
from baidubce.bce_client_configuration import BceClientConfiguration
from baidubce.auth.bce_credentials import BceCredentials


def generate_client_token_by_uuid():
    """
    The default method to generate the random string for client_token
    if the optional parameter client_token is not specified by the user.

    :return:
    :rtype string
    """
    return str(uuid.uuid4())


def test_create_ipv6_gateway_egress_only_rule(ipv6gateway_client, client_token, gateway_id, cidr):
    """
    create ipv6 gateway egress only rule.

    :param client_token:
        An ASCII string whose length is less than 64.
        The request will be idempotent if clientToken is provided.
        If the clientToken is not specified by user,
        a random String generated by default algorithm will be used.
    :type client_token: string

    :param gateway_id:
        the ipv6 gateway ID.
    :type gateway_id: string

    :param cidr:
        cidr of the ipv6.
    :type cidr: string

    :return:
    :rtype baidubce.bce_response.BceResponse

    Raise:
        BceHttpClientError: http request error
    """
    try:
        res = ipv6gateway_client.create_ipv6_gateway_egress_only_rule(client_token=client_token,
                                                                      gateway_id=gateway_id, cidr=cidr)
        return res
    except exception.BceHttpClientError as e:
        # 异常处理
        print(e.last_error)
        print(e.request_id)
        print(e.code)
        return None


if __name__ == "__main__":

    # create a ipv6 gateway client
    HOST = b''
    AK = b''
    SK = b''
    config = BceClientConfiguration(credentials=BceCredentials(AK, SK), endpoint=HOST)

    ipv6gateway_client = IPv6GatewayClient(config)
    client_token = generate_client_token_by_uuid()
    gateway_id = b'ipv6-xx'
    res = test_create_ipv6_gateway_egress_only_rule(ipv6gateway_client, client_token, gateway_id,
                                                    cidr="2400:da00:e003:d01::/64")

    print(res)
    print(res.egress_only_rule_id)
