# !/usr/bin/env python
# coding=utf-8
"""
Samples for nat client.
"""
import uuid

from baidubce import exception
from baidubce.services.vpc import nat_model
from baidubce.services.vpc.nat_client import NatClient
from baidubce.bce_client_configuration import BceClientConfiguration
from baidubce.auth.bce_credentials import BceCredentials
from baidubce.services.bcc.bcc_model import TagModel


def generate_client_token_by_uuid():
    """
    The default method to generate the random string for client_token
    if the optional parameter client_token is not specified by the user.

    :return:
    :rtype string
    """
    return str(uuid.uuid4())

def test_create_enhance_nat(nat_client, client_token, name, VPC_ID, billing, cu_num, bind_eips, tags, resource_group_id,
                            delete_protect):
   """
    create enhance nat.

    :param client_token:
        An ASCII string whose length is less than 64.
        The request will be idempotent if clientToken is provided.
        If the clientToken is not specified by user,
        a random String generated by default algorithm will be used.
    :type client_token: string

    :param name:
        nat's name
    :type name: string

    :param VPC_ID:
        the VPC ID of the nat.
    :type VPC_ID: string

    :param billing:
        billing info
    :type billing: nat_model.Billing

    :param cu_num:
        CU number
    :type cu_num: int

    :return:
    :rtype baidubce.bce_response.BceResponse

    Raise:
        BceHttpClientError: http request error
    """
   try:
       res = nat_client.create_nat(client_token=client_token, name=name, vpc_id=VPC_ID, bind_eips=bind_eips,
                                   billing=billing, cu_num=cu_num, tags=tags, resource_group_id=resource_group_id,
                                   delete_protect=delete_protect)
       return res
   except exception.BceHttpClientError as e:
       # 异常处理
       print(e.last_error)
       print(e.request_id)
       print(e.code)
       return None

if __name__ == "__main__":
    post_paid_billing = nat_model.Billing('Postpaid')
    VPC_ID = b'vpc-xx'

    # create a nat client
    HOST = b''
    AK = b''
    SK = b''
    config = BceClientConfiguration(credentials=BceCredentials(AK, SK), endpoint=HOST)

    nat_client = NatClient(config)
    client_token = generate_client_token_by_uuid()
    name = 'enhance_nat_' + client_token
    cu_num = 10
    bind_eips = ['xxxx']
    tags = [TagModel(tagKey='tagKey1', tagValue='tagValue1')]
    resource_group_id = 'RESG-xxx'
    res = test_create_enhance_nat(nat_client, client_token, name, VPC_ID, post_paid_billing, cu_num,
                                  bind_eips, tags, resource_group_id, True)

    print(res)
    print(res.nat_id)
