# Copyright (c) 2014 Baidu.com, Inc. All Rights Reserved
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
# an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
# specific language governing permissions and limitations under the License.
"""
Samples for bcc client.
"""

# !/usr/bin/env python
# coding=utf-8

from baidubce.services.bcc import bcc_model
from baidubce.services.bcc.bcc_client import BccClient
from sample.bcc import bcc_sample_conf

if __name__ == "__main__":
    import logging

    logging.basicConfig(level=logging.DEBUG)
    __logger = logging.getLogger(__name__)
    bcc_client = BccClient(bcc_sample_conf.config)

    response = bcc_client.create_reserved_instances(reserved_instance_name="test_create_reserved_instances",
                                                    scope="AZ",
                                                    zone_name="cn-bj-a",
                                                    spec="bcc.g5.c2m8",
                                                    offering_type="FullyPrepay",
                                                    instance_count=1,
                                                    reserved_instance_count=1,
                                                    reserved_instance_time=1,
                                                    reserved_instance_time_unit="month",
                                                    auto_renew_time_unit="month",
                                                    auto_renew_time=1,
                                                    auto_renew=True,
                                                    tags=[bcc_model.TagModel("k1", "v1")])

    # 打印返回结果
    print(response)
