# !/usr/bin/env python
# coding=utf-8
"""
Samples for nat client.
"""

from baidubce import exception
from baidubce.services.vpc.nat_client import NatClient, generate_client_token
from baidubce.bce_client_configuration import BceClientConfiguration
from baidubce.auth.bce_credentials import BceCredentials


def test_update_nat_delete_protect(nat_client, nat_id, delete_protect, client_token=None):
    """
    Resize a specified enhance nat-gateway.

    :param nat_id:
        The id of specified nat-gateway.
    :type nat_id: string

    :param delete_protect:
        Whether to enable deletion protection on the nat.
    :type delete_protect: bool

    :param client_token:
        An ASCII string whose length is less than 64.
        The request will be idempotent if clientToken is provided.
        If the clientToken is not specified by user,
        a random String generated by default algorithm will be used.
    :type client_token: string

    :return:
    :rtype baidubce.bce_response.BceResponse

    Raise:
        BceHttpClientError: http request error
    """
    try:
        res = nat_client.update_delete_protect(nat_id, delete_protect, client_token)
        return res
    except exception.BceHttpClientError as e:
        # 异常处理
        print(e.last_error)
        print(e.request_id)
        print(e.code)
        return None


if __name__ == "__main__":
    # create a nat client
    HOST = b''
    AK = b''
    SK = b''
    config = BceClientConfiguration(credentials=BceCredentials(AK, SK), endpoint=HOST)

    nat_client = NatClient(config)

    nat_id = "nat-xx"
    client_token = generate_client_token()  # when you retry, please use the same client_token
    res = test_update_nat_delete_protect(nat_client, nat_id, True, client_token)

