#pragma once

#include <vector>

#include "bcesdk/model/bce_request.h"
#include "bcesdk/common/memory_stream.h"

BEGIN_CPPSDK_NAMESPACE

class DeleteMultiObjectsRequest : public BceRequest
{
public:
    DeleteMultiObjectsRequest(const std::string &bucket_name)
        : _content(NULL), _content_stream(NULL)
    {
        set_bucket_name(bucket_name);
    }

    virtual ~DeleteMultiObjectsRequest()
    {
        if (_content)
        {
            delete _content;
            _content = NULL;
        }

        if (_content_stream)
        {
            delete _content_stream;
            _content_stream = NULL;
        }
    }

    int add_object(const std::string &object_name, const std::string &object_version = "")
    {
        if (_objects.size() >= 1000) {
            return RET_ILLEGAL_ARGUMENT;
        }

        _objects.push_back({object_name, object_version});
        return RET_OK;
    }

    int build_command_specific(HttpRequest *request);

private:
    std::string        *_content;
    InputStream        *_content_stream;

    std::vector<std::pair<std::string, std::string>> _objects;
};

END_CPPSDK_NAMESPACE
