/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
#ifndef BAIDU_BOS_CPPSDK_BOS_REQUEST_HEAD_OBJECT_REQUEST_H
#define BAIDU_BOS_CPPSDK_BOS_REQUEST_HEAD_OBJECT_REQUEST_H

#include "bcesdk/bos/model/object_request.h"

BEGIN_CPPSDK_NAMESPACE

class HeadObjectRequest : public ObjectRequest {
public:
    HeadObjectRequest(const std::string &bucket_name, const std::string &object_name, const std::string &version_id = "")
        : ObjectRequest(bucket_name, object_name), _version_id(version_id), _support_head_prefix(false) {};

    virtual ~HeadObjectRequest()
    {
        // nothing to do
        
    }

    void set_version_id(const std::string &version_id) {
        _version_id = version_id;
    }

    std::string version_id() const {
        return _version_id;
    }

    void set_support_head_prefix(bool is_true) {
        _support_head_prefix = is_true;
    }

    int build_command_specific(HttpRequest *request) {
        request->set_method(HTTP_METHOD_HEAD);
        if (!_version_id.empty()){
            request->add_parameter("versionId", _version_id);
        }
        if (_support_head_prefix) {
            request->append_header("x-bce-head-prefix", "true");
        }
        return 0;
    }
private:
    std::string _version_id;
    bool _support_head_prefix;
};

END_CPPSDK_NAMESPACE
#endif

