/**
 * Copyright 2024 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
#ifndef BAIDU_BOS_CPPSDK_BOS_REQUEST_PUT_BUCKET_LOGGING_REQUEST_H
#define BAIDU_BOS_CPPSDK_BOS_REQUEST_PUT_BUCKET_LOGGING_REQUEST_H

#include "bcesdk/bos/request/put_bucket_request.h"
#include "bcesdk/bos/model/upload_request.h"
#include "bcesdk/bos/model/bucket_meta_data.h"

BEGIN_CPPSDK_NAMESPACE

class PutBucketLoggingRequest : public PutBucketRequest, public UploadRequest {
public:
    PutBucketLoggingRequest(const std::string &bucket_name, const std::string &target_bucket) :
        PutBucketRequest(bucket_name), _target_bucket(target_bucket) {
    }

    PutBucketLoggingRequest();

    virtual ~PutBucketLoggingRequest(){
    }

    void set_target_bucket(const std::string &target_bucket) {
        _target_bucket = target_bucket;
    }

    void set_target_prefix(const std::string &target_prefix) {
        _target_prefix = target_prefix;
    }

    int serialize_to_json(std::string *json_str);

    int build_command_specific(HttpRequest *request){
        request->set_method(HTTP_METHOD_PUT);
        request->add_parameter("logging");
        std::string json_str;
        serialize_to_json(&json_str);
        InputStream* _stream = new MemoryInputStream(json_str.data(), json_str.size());
        request->set_input_stream(_stream);
        return RET_OK;
    }
    


private:

    std::string _target_bucket;
    std::string _target_prefix;

};



END_CPPSDK_NAMESPACE
#endif