/**
 * Copyright 2019 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
#ifndef BAIDU_BOS_CPPSDK_BOS_REQUEST_PUT_SYMLINK_REQUEST_H
#define BAIDU_BOS_CPPSDK_BOS_REQUEST_PUT_SYMLINK_REQUEST_H 

#include "bcesdk/bos/model/object_request.h"

BEGIN_CPPSDK_NAMESPACE

class PutSymlinkRequest : public ObjectMetaRequest {
public:
    PutSymlinkRequest(const std::string &bucket_name, const std::string &object_name): 
      ObjectMetaRequest(bucket_name, object_name) {
    }

    virtual ~PutSymlinkRequest() {}

    void set_symlink_target(const std::string& target) {
        _symlink_target = target;
    }

    void set_forbid_overwrite(bool forbid_overwrite) {
        _forbid_overwrite = forbid_overwrite? "true":"false";
    }

    void set_symlink_bucket(const std::string& bucket) {
        _symlink_bucket = bucket;
    }

    virtual int build_command_specific(HttpRequest *request) {
        request->set_method(HTTP_METHOD_PUT);
        request->add_parameter("symlink");
        if (!_symlink_target.empty())  {
            request->append_header("x-bce-symlink-target", _symlink_target);
        }
        if (!_forbid_overwrite.empty())  {
            request->append_header("x-bce-forbid-overwrite", _forbid_overwrite);
        }
        if (!_symlink_bucket.empty())  {
            request->append_header("x-bce-symlink-bucket", _symlink_bucket);
        }
        append_all_meta_to(request);
        return 0;
    }
private:
    std::string _symlink_target;
    std::string _forbid_overwrite;
    std::string _symlink_bucket;
};

END_CPPSDK_NAMESPACE
#endif

