/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

#include "bcesdk/model/json_response.h"

BEGIN_CPPSDK_NAMESPACE

struct DeleteErrorResult {
    std::string key;
    std::string version_id;
    std::string code;
    std::string message;
    bool delete_marker;
    std::string delete_marker_version_id;
};

class DeleteMultiObjectsResponse : public JsonResponse {
public:
    DeleteMultiObjectsResponse() {}
    virtual ~DeleteMultiObjectsResponse() {}

    std::vector<DeleteErrorResult> &errors() {
        return _errors;
    }

    virtual int deserialize(Json::Value &root);

private:
    std::vector<DeleteErrorResult> _errors;
};

END_CPPSDK_NAMESPACE
