/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
#ifndef BAIDU_BOS_CPPSDK_BOS_STS_REQUEST_ASSUME_ROLE_REQUEST_H
#define BAIDU_BOS_CPPSDK_BOS_STS_REQUEST_ASSUME_ROLE_REQUEST_H

#include "bcesdk/model/bce_request.h"

BEGIN_CPPSDK_NAMESPACE

class AssumeRoleRequest : public BceRequest {
public:
    AssumeRoleRequest(const std::string &duration_seconds, const std::string &account_id, const std::string &role_name)
            :
            _duration_seconds(duration_seconds), _account_id(account_id), _role_name(role_name) {};

    virtual ~AssumeRoleRequest()
    {
        // nothing to do
        
    }

    virtual int build_command_specific(HttpRequest *request) {
        request->set_method(HTTP_METHOD_POST);
        request->append_header("Content-Type", "application/json");
        request->add_parameter("assumeRole");
        request->add_parameter("accountId", _account_id);
        request->add_parameter("durationSeconds", _duration_seconds);
        request->add_parameter("roleName", _role_name);
        return 0;
    }


    virtual std::string get_uri(bool cname_enabled) const
    {
        std::stringstream ss;
        ss << "/v1/credential";
        return ss.str();
    }

private:
    std::string _duration_seconds;
    std::string _account_id;
    std::string _role_name;
};

END_CPPSDK_NAMESPACE
#endif

