/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

#include "bcesdk/bos/response/delete_object_response.h"
#include "bcesdk/util/util.h"
#include <iostream>
#include <json/json.h>

BEGIN_CPPSDK_NAMESPACE

int DeleteObjectResponse::deserialize_header(HttpResponse &response) {
    _deleted_version_id = response.header("x-bce-version-id");
    return RET_OK;
}

int DeleteObjectResponse::deserialize(Json::Value &root) {
    _next_delete_token = root["nextDeleteToken"].asString();
    _is_truncated = root["isTruncated"].asBool();
    _delete_number = root["deleteNumber"].asInt();
    return RET_OK;
}

END_CPPSDK_NAMESPACE

