/**
 * Copyright 2024 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
#include "bcesdk/bos/response/fetch_object_response.h"
#include "bcesdk/util/util.h"
#include <json/json.h>

BEGIN_CPPSDK_NAMESPACE

int FetchObjectResponse::deserialize(Json::Value &root) {
    _code = root["code"].asString();
    _message = root["message"].asString();
    _requestId = root["requestId"].asString();

    //jobId might be null
    Json::Value &jobId = root["jobId"];
    if (jobId.isNull()) {
        _jobId = "";
    }
    else {
        _jobId = jobId.asString();
    }
    return RET_OK;
}

END_CPPSDK_NAMESPACE
/* vim: set expandtab ts=4 sw=4 sts=4 tw=100: */
