/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
#ifndef BAIDU_BOS_CPPSDK_BOS_MODEL_BUCKET_DATA_H
#define BAIDU_BOS_CPPSDK_BOS_MODEL_BUCKET_DATA_H

#include <string>
#include <vector>
#include "bcesdk/common/common.h"

namespace Json {
class Value;
}

BEGIN_CPPSDK_NAMESPACE

struct BucketDirPaths {
    std::vector<std::string> dir_paths;
    static int serialize_to_json(const BucketDirPaths &st, std::string &json_str);
};

struct BucketDirQuotaInfo {
    BucketDirQuotaInfo() : dir_path(""), inode_capacity(0), 
                            storage_capacity(0), inode_used(0), storage_used(0) {}
    std::string dir_path;
    int64_t inode_capacity;
    int64_t storage_capacity;
    int64_t inode_used;
    int64_t storage_used;
};

struct BucketQuotaInfo {
    BucketQuotaInfo() : max_object_count(0), max_capacity_mega_bytes(0) {}
    int64_t  max_object_count;
	int64_t  max_capacity_mega_bytes;
    std::vector<BucketDirQuotaInfo> dir_quotas;

    static int serialize_to_json(const BucketQuotaInfo &st, std::string &json_str);
    static int deserialize_to_struct(Json::Value &root, BucketQuotaInfo &st);
};



END_CPPSDK_NAMESPACE

#endif
