/**
* Copyright 2014 (c) Baidu, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
* the License. You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
* an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
* specific language governing permissions and limitations under the License.
*/
#ifndef BAIDU_BOS_CPPSDK_BOS_REQUEST_DELETE_BUCKET_QUOTA_REQUEST_H
#define BAIDU_BOS_CPPSDK_BOS_REQUEST_DELETE_BUCKET_QUOTA_REQUEST_H

#include "bcesdk/bos/model/bucket_request.h"
#include "bcesdk/bos/model/upload_request.h"
#include "bcesdk/bos/model/bucket_meta_data.h"

BEGIN_CPPSDK_NAMESPACE

class DeleteBucketQuotaRequest : public BucketRequest, public UploadRequest {
public:
   DeleteBucketQuotaRequest(const std::string &bucket_name) : BucketRequest(bucket_name) {
   }
   virtual ~DeleteBucketQuotaRequest() {}

   void add_delete_dir(const std::string &dir) {
       _dir_paths.dir_paths.push_back(dir);
   }

   int build_command_specific(HttpRequest *request) {
       request->set_method(HTTP_METHOD_DELETE);
       request->add_parameter("quota");
       std::string json_str;
        if (BucketDirPaths::serialize_to_json(_dir_paths, json_str)) {
                return RET_ILLEGAL_ARGUMENT;
        }
        UploadRequest::set_data(json_str); 
        UploadRequest::set_calc_md5_on(false); 
        return UploadRequest::fill_http_request(request);
   }

private:
    BucketDirPaths _dir_paths;
};

END_CPPSDK_NAMESPACE
#endif

