/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
#ifndef BAIDU_BOS_CPPSDK_BOS_REQUEST_DELETE_OBJECT_REQUEST_H
#define BAIDU_BOS_CPPSDK_BOS_REQUEST_DELETE_OBJECT_REQUEST_H

#include "bcesdk/bos/model/object_request.h"

BEGIN_CPPSDK_NAMESPACE

class DeleteObjectRequest : public ObjectRequest {
public:
    DeleteObjectRequest(const std::string &bucket_name, const std::string &object_name, const std::string &version_id = "")
        : ObjectRequest(bucket_name, object_name), _delete_recursive(false), _version_id(version_id)  {}
    virtual ~DeleteObjectRequest() {}

    void set_delete_recursive (bool delete_recursive) {
        _delete_recursive = delete_recursive;
    }

    void set_delete_token (const std::string &delete_token) {
        _delete_token = delete_token;
    }

    void set_version_id (const std::string &version_id) {
        _version_id = version_id;
    }
    
    int build_command_specific(HttpRequest *request) {
        request->set_method(HTTP_METHOD_DELETE);
        if (_delete_recursive) {
            request->append_header("x-bce-delete-recursive", "true");
        }
        if (!_delete_token.empty()) {
            request->append_header("x-bce-delete-token", StringUtil::url_encode(_delete_token));
        }
        if (!_version_id.empty()) {
            request->add_parameter("versionId", _version_id);
        }
        return 0;
    }

private:
    bool _delete_recursive;
    std::string _delete_token;
    std::string _version_id;
};

END_CPPSDK_NAMESPACE
#endif

