/**
 * Copyright 2024 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

#ifndef BAIDU_BOS_CPPSDK_BOS_REQUEST_FETCH_OBJECT_REQUEST_H
#define BAIDU_BOS_CPPSDK_BOS_REQUEST_FETCH_OBJECT_REQUEST_H

#include "bcesdk/bos/model/object_request.h"

BEGIN_CPPSDK_NAMESPACE

class FetchObjectRequest : public ObjectRequest {
public:
    FetchObjectRequest(const std::string& bucket_name, const std::string& object_name, std::string& url) : 
        ObjectRequest(bucket_name, object_name), _url(url) {
    }
    
    virtual ~FetchObjectRequest(){
    };

    void set_storage_class(const std::string& storage_class) {
        _storage_class = storage_class;
    }

    void set_fetch_mode(const std::string& fetch_mode) {
        _fetch_mode = fetch_mode;
    }

    void set_url(const std::string& url) {
        _url = url;
    }

    void set_server_side_encryption(const std::string& server_side_encryption) {
        _server_side_encryption = server_side_encryption;
    }

    void set_callback_address(const std::string& callback_address) {
        _callback_address = callback_address;
    }

    void set_referer(const std::string& referer) {
        _referer = referer;
    }

    void set_user_agent(const std::string& user_agent) {
        _user_agent = user_agent;
    }



    virtual int build_command_specific(HttpRequest *request) {
        request->set_method(HTTP_METHOD_POST);
        request->add_parameter("fetch");

        request->append_header("x-bce-fetch-source", _url);
        if (!_storage_class.empty()){
            request->append_header("x-bce-storage-class", _storage_class);
        }
        if (!_fetch_mode.empty()){
            request->append_header("x-bce-fetch-mode", _fetch_mode);
        }
        if (!_server_side_encryption.empty()){
            request->append_header("x-bce-server-side-encryption", _server_side_encryption);
        }
        if (!_callback_address.empty()){
            request->append_header("x-bce-callback-address", _callback_address);
        }
        if (!_referer.empty()){
            request->append_header("Referer", _referer);
        }
        if (!_user_agent.empty()){
            request->append_header("User-Agent", _user_agent);
        }   
        
        return 0;
    }

private:
    std::string _url;
    std::string _storage_class;
    std::string _fetch_mode;
    std::string _server_side_encryption;
    std::string _callback_address;
    std::string _referer;
    std::string _user_agent;

};


END_CPPSDK_NAMESPACE

#endif