/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
#ifndef BAIDU_BOS_CPPSDK_BOS_REQUEST_PUT_BUCKET_QUOTA_REQUEST_H
#define BAIDU_BOS_CPPSDK_BOS_REQUEST_PUT_BUCKET_QUOTA_REQUEST_H

#include "bcesdk/bos/request/put_bucket_request.h"
#include "bcesdk/bos/model/upload_request.h"
#include "bcesdk/bos/model/bucket_meta_data.h"

BEGIN_CPPSDK_NAMESPACE

class PutBucketQuotaRequest : public PutBucketRequest, public UploadRequest {
public:
    PutBucketQuotaRequest(const std::string &bucket_name) :
        PutBucketRequest(bucket_name) {
    }
   

    virtual ~PutBucketQuotaRequest() {
    }

    void set_bucket_max_object_count(int64_t v) {
        _bucket_quota.max_object_count = v;
    }

    void set_bucket_max_capacity_mega_bytes(int64_t v) {
        _bucket_quota.max_capacity_mega_bytes = v;
    }

    void add_dir_quota(const std::string & dir_path, 
                int64_t inode_capacity, int64_t storage_capacity) {
        BucketDirQuotaInfo dir_quota;
        dir_quota.dir_path =  dir_path;
        dir_quota.inode_capacity = inode_capacity;
        dir_quota.storage_capacity = storage_capacity;
        _bucket_quota.dir_quotas.push_back(dir_quota);
    }

    int build_command_specific(HttpRequest *request) {
        request->set_method(HTTP_METHOD_PUT);
        request->add_parameter("quota");
        std::string json_str;
        if (BucketQuotaInfo::serialize_to_json(_bucket_quota, json_str)) {
                return RET_ILLEGAL_ARGUMENT;
        }
        UploadRequest::set_data(json_str); 
        UploadRequest::set_calc_md5_on(false); 
        return UploadRequest::fill_http_request(request);
    }

private:
    BucketQuotaInfo _bucket_quota;
};

END_CPPSDK_NAMESPACE
#endif
/* vim: set expandtab ts=4 sw=4 sts=4 tw=100: */
