/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
#ifndef BAIDU_BOS_CPPSDK_BOS_REQUEST_PUT_BUCKET_REQUEST_H
#define BAIDU_BOS_CPPSDK_BOS_REQUEST_PUT_BUCKET_REQUEST_H

#include "bcesdk/bos/model/bucket_request.h"
#include "bcesdk/common/memory_stream.h"

BEGIN_CPPSDK_NAMESPACE

class PutBucketRequest : public BucketRequest {
public:
    PutBucketRequest(const std::string &bucket_name) :
        BucketRequest(bucket_name), _enable_multi_az(false),  _stream(NULL) {
    }

    ~PutBucketRequest() {
        release_stream();
    }

    void set_enable_multi_az(bool enable) {
        _enable_multi_az = enable;
    }

    void set_meta_type(const std::string &meta_type) {
        _meta_type = meta_type;
    }

    void release_stream() {
        if (_stream != NULL) {
            delete _stream;
        }
        _stream = NULL;
    }

    virtual int serialize_to_json(std::string *json_str);

    inline void set_data(const std::string &data) {
        release_stream();
        _stream = new MemoryInputStream(data.data(), data.size());
    }

    virtual int build_command_specific(HttpRequest *request) {
        request->set_method(HTTP_METHOD_PUT);
        if ((!_meta_type.empty() && (_meta_type == bucket_type_hierarchy_str
        || _meta_type == bucket_type_hierarchy_xh_str))
        || _enable_multi_az) {
            std::string json_str;
            if (serialize_to_json(&json_str)) {
                return RET_ILLEGAL_ARGUMENT;
            }
            set_data(json_str); 
            request->set_input_stream(_stream);
        }
        return 0;
    }

private:
    std::string _meta_type;
    bool _enable_multi_az;
    InputStream * _stream;
};

END_CPPSDK_NAMESPACE
#endif
/* vim: set expandtab ts=4 sw=4 sts=4 tw=100: */
