/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
#ifndef BAIDU_BOS_CPPSDK_BOS_RESPONSE_DELETE_OBJECT_RESPONSE_H
#define BAIDU_BOS_CPPSDK_BOS_RESPONSE_DELETE_OBJECT_RESPONSE_H

#include <string>

#include "bcesdk/model/json_response.h"
#include "bcesdk/model/bce_response.h"

BEGIN_CPPSDK_NAMESPACE

class DeleteObjectResponse : public JsonResponse {
public:
    DeleteObjectResponse() : _is_truncated(false), _delete_number(-1), _deleted_version_id("")  {
    }

    const std::string &version() const {
        return attribute("x-bce-version");
    }

    std::string next_delete_token() const {
        return _next_delete_token;
    }

    bool is_truncated() const {
        return _is_truncated;
    }

    int32_t delete_number() const {
        return _delete_number;
    }

    const std::string deleted_version_id() const {
        return _deleted_version_id;
    }

    virtual int deserialize_header(HttpResponse &response);

    virtual int deserialize(Json::Value &root);

private:
    std::string _next_delete_token;
    bool _is_truncated;
    int32_t _delete_number;
    std::string _deleted_version_id;
};

END_CPPSDK_NAMESPACE
#endif

