/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
#ifndef BAIDU_BOS_CPPSDK_BOS_RESPONSE_FETCH_OBJECT_RESPONSE_H
#define BAIDU_BOS_CPPSDK_BOS_RESPONSE_FETCH_OBJECT_RESPONSE_H

#include "bcesdk/model/json_response.h"

BEGIN_CPPSDK_NAMESPACE

class FetchObjectResponse : public JsonResponse {
public:
    FetchObjectResponse() {}
    virtual ~FetchObjectResponse() {}

    const std::string& code() const { 
        return _code; 
    }

    const std::string& message() const { 
        return _message; 
    }

    const std::string& requestId() const { 
        return _requestId; 
    }

    const std::string& jobId() const { 
        return _jobId; 
    }
    
    virtual int deserialize(Json::Value &root);
private:
    std::string _code;
    std::string _message;
    std::string _requestId;
    std::string _jobId;
};

END_CPPSDK_NAMESPACE
#endif

