/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
#ifndef BAIDU_BOS_CPPSDK_BOS_REQUEST_HEAD_BUCKET_RESPONSE_H
#define BAIDU_BOS_CPPSDK_BOS_REQUEST_HEAD_BUCKET_RESPONSE_H

#include "bcesdk/model/bce_response.h"

BEGIN_CPPSDK_NAMESPACE

class HeadBucketResponse : public BceResponse {
public:
    HeadBucketResponse()
    {
        // nothing to do
    }

    virtual ~HeadBucketResponse()
    {
        // nothing to do
    }

    BucketType bucket_type() {
        std::string bt = attribute("x-bce-bucket-type");
        if (is_ok() && bt.empty()) {
            _bucket_type = FLAT;
        } else if (is_ok() && bt == "namespace") {
            _bucket_type = HIERARCHY;
        } else {
            _bucket_type = FLAT;
        }

        std::string bt_detail = attribute("x-bce-bucket-type-details");
        if (is_ok() && !bt_detail.empty()) {
            if (is_ok() && bt_detail == "namespace") {
                _bucket_type = HIERARCHY;
            } else if (is_ok() && bt_detail == "namespace-xh") {
                _bucket_type = HIERARCHY_XH;
            }
        }
        return _bucket_type;
    }

    bool is_hierarchy_bucket_type() {
        std::string bt = attribute("x-bce-bucket-type");
        if (is_ok() && bt.empty()) {
            return false;
        } else if (is_ok() && bt == "namespace") {
            return true; 
        } else {
            return false;
        }
    }

private:
    BucketType _bucket_type = UNKNOWN;
};

END_CPPSDK_NAMESPACE
#endif
/* vim: set expandtab ts=4 sw=4 sts=4 tw=100: */
