/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

#include "bcesdk/bos/request/delete_multi_objects_request.h"
#include <json/json.h>

BEGIN_CPPSDK_NAMESPACE

int DeleteMultiObjectsRequest::build_command_specific(HttpRequest *request)
{
    request->set_method(HTTP_METHOD_POST);
    request->add_parameter("DELETE");

    Json::Value value;
    for (auto it = _objects.begin(); it != _objects.end(); it++) {
        Json::Value tmp;
        tmp["key"] = Json::Value(it->first);
        tmp["versionId"] = Json::Value(it->second);
        value["objects"].append(tmp);
    }

    Json::FastWriter fast_writer;
    _content = new std::string("");
    if (!value.isNull()) {
        _content->assign(fast_writer.write(value));
    }

    if (!_content->empty()) { // erase the end of \n for mock
        _content->erase(_content->end() - 1, _content->end());
    }

    _content_stream = new MemoryInputStream(_content->data(), _content->size());
    LOGF(DEBUG, "request body: %s", _content->c_str());

    request->set_input_stream(_content_stream);
    // request->append_header("Content-Type", "application/json");
    return 0;
}

END_CPPSDK_NAMESPACE
