/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
#include <sstream>
#include "bcesdk/bos/request/put_bucket_logging_request.h"
#include "bcesdk/util/util.h"
#include <json/json.h>

BEGIN_CPPSDK_NAMESPACE

int PutBucketLoggingRequest::serialize_to_json(std::string *json_str) {
    Json::Value root;
    if (!_target_bucket.empty()) {
        root["targetBucket"] = Json::Value(_target_bucket);
    }
    else {
        return RET_ILLEGAL_OPERATION;
    }
    if (!_target_prefix.empty()) {
        root["targetPrefix"] = Json::Value(_target_prefix);
    }
    Json::FastWriter writer;
    *json_str = writer.write(root);

    return RET_OK;
}

END_CPPSDK_NAMESPACE
