/**
 * Copyright 2014 (c) Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
#include <sstream>
#include "bcesdk/bos/request/put_bucket_request.h"
#include "bcesdk/util/util.h"
#include <json/json.h>

BEGIN_CPPSDK_NAMESPACE

int PutBucketRequest::serialize_to_json(std::string *json_str) {
    try {
        if (!json_str) {
            return RET_ILLEGAL_OPERATION;
        }
        Json::Value root;
        if (_enable_multi_az) {
            root["enableMultiAz"] = Json::Value(_enable_multi_az);
        }
        if (!_meta_type.empty() && (_meta_type == bucket_type_hierarchy_str
            || _meta_type == bucket_type_hierarchy_xh_str)) {
            root["metaType"] = Json::Value(_meta_type);
        }
        Json::FastWriter writer;
        *json_str = writer.write(root);
    } catch (...) {
        LOGF(ERROR, "serialize put bucket req to json exceptional!");
        return RET_ILLEGAL_OPERATION;
    }
    return RET_OK;
}

END_CPPSDK_NAMESPACE
/* vim: set expandtab ts=4 sw=4 sts=4 tw=100: */
