//
// Created by wangchangshui on 2020-02-05.
//

#include <string>
#include <iostream>
#include <cstdlib>

#include "bcesdk/bos/sts_client.h"
#include "bcesdk/bos/client_impl.h"
#include "bcesdk/util/util.h"

BEGIN_CPPSDK_NAMESPACE

StsClient::StsClient(const std::string &access_key_id, const std::string &access_key_secret) {
    ClientOptions option;
    option.endpoint = "http://sts.bj.iam.sdns.baidu.com:8586";
    _impl = new ClientImpl(Credential(access_key_id, access_key_secret), option);
}

StsClient::StsClient(const std::string &access_key_id, const std::string &access_key_secret,
                     const ClientOptions &options) {
    _impl = new ClientImpl(Credential(access_key_id, access_key_secret), options);
}


StsClient::~StsClient() {
    if (_impl) {
        delete _impl;
        _impl = NULL;
    }
}

int StsClient::AssumeRole(baidu::bos::cppsdk::AssumeRoleRequest &request,
                          baidu::bos::cppsdk::AssumeRoleResponse *response) {
    return _impl->send_request(request, response);
}

END_CPPSDK_NAMESPACE
