var isWeixinJSBridgeReady = false
function addClickCallback(callback) {
    let selectClass = 'ui-radio-selected';
    let radioList = document.querySelectorAll(".ui-radio-block");
    let selectEle = document.querySelector(`.${selectClass}`);
    radioList.forEach(radio => {
        radio.addEventListener("click", function (event) {
            event.target.classList.add(selectClass);
            selectEle.classList.remove(selectClass);
            selectEle = event.target;
            callback(event.target.getAttribute('data-type'));
        });
    })
}

function getHtml(type) {
    let config = selectTypeOpt(type);
    var html = `<!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8" />
        <meta http-equiv="cache-control" content="no-cache, no-store, must-revalidate">
        <title>百度云-cyberplayer</title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
        <script type="text/javascript" src="./output/cyberplayer.js"></script>
    </head>
    <body>
        <div>
            <div id="playerContainer"></div>
        </div>
    </body>
    <script>
        function defaultOpt() {
            return ${setHuanHang(config)}
        }
        window.player = cyberplayer('playerContainer').setup(defaultOpt());
        ${getPlayerfun(type)}
    </script>
    </html>`
    return html
}

function defaultOpt() {
    return {
        title: "'基本功能'", // 标题
        image: "'http://cyberplayer.bcelive.com/thumbnail.jpg'", // 预览图 
        width: 640,
        height: 360,
        autostart: true,
        stretching: "'uniform'",
        appid:"'122228461623145164803p'",
        licenseUrl:"'./assets/player046689212a8f186bbc0fa8460359d07a.license'", // 高级版 域名为*.bcelive.com
        // appid:"'122228455771558400003p'",
        // licenseUrl:"'./assets/player87af54c654d4bd97b163073d4470351e.license'", // 标准版 域名为*.bcelive.com
        repeat: false,
        volume: 100,
        controls: true,
    }
}

function setHuanHang(config) {
    let nConfig = '{\n';
    let length = Object.keys(config).length;
    Object.keys(config).forEach(key => {
        if (Array.isArray(config[key])) {
            nConfig += `                 ${key}:${JSON.stringify(config[key])},\n`;
        } else {
            if (Object.keys(config)[length - 1] == key) {
                nConfig += `                 ${key}:${config[key]}\n              }`;
            } else {
                nConfig += `                 ${key}:${config[key]},\n`;
            }
        }
    })
    return nConfig
}

function selectTypeOpt(type) {
    let defaultObj = defaultOpt();
    return Object.assign(defaultObj, getFileConfig(type))
}
function getFileConfig(type) { 
    let fileConfig = {
        vr:{
            file: `"${selectPlayUrl(0, 'mp4', 'vr')}"`,
            VRPlugin: JSON.stringify({
                initialYaw: 90,  // 初始设置：沿Y轴旋转，改变左右视角角度
                initialPitch:0,
                fov:90
            }),
            title: "'VR播放'"
        },
        dash: {
            file: `"${selectPlayUrl(0, 'dash', 'avc')}"`,
            title: "'dash点播'"
        },
        mp4: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            title: "'基本功能'"
        },
        flv: {
            file: `"${selectPlayUrl(0, 'flv', 'avc')}"`,
            headers:JSON.stringify({
                authtoken:"XXXXXX",
            }),
            title: "'flv点播'"
        },
        hls: {
            file: `"${selectPlayUrl(0, 'hls', 'avc')}"`,
            title: "'hls点播'"
        },
        adaptive: {
            file: `"${selectPlayUrl(0, 'hls', 'avc')}"`,
            title: "'自适应hls'"
        },
        multirate: {
            title: "'playlist'", // 标题
            playlist: [
                {
                    sources: [
                        {
                            file: `${selectPlayUrl(0, 'quality', 'HD')}`,
                            label: "高清"
                        },
                        {
                            file: `${selectPlayUrl(0, 'quality', 'SD')}`,
                            label: "标清"
                        }
                    ],
                    title: "线路1"
                }
            ],
            isLive: false,
        },
        playlist: {
            title: "'playlist'", // 标题
            playlist: [
                {
                    sources: [
                        {
                            file: `${selectPlayUrl(0, 'quality', 'HD')}`,
                            label: "高清1"
                        },
                        {
                            file: `${selectPlayUrl(0, 'quality', 'HD')}`,
                            label: "标清2"
                        }
                    ],
                    title: "线路1"
                },
                {
                    sources: [
                        {
                            file: `${selectPlayUrl(0, 'quality', 'HD')}`,
                            label: "高清"
                        },
                        {
                            file: `${selectPlayUrl(0, 'quality', 'HD')}`,
                            label: "标清"
                        }
                    ],
                    title: "线路2"
                }
            ],
            isLive: false,
        },
        dadian: {
            title: "'打点及缩略图'", 
            playlist: [
                {
                    sources: [
                        {
                            file: `${selectPlayUrl(0, 'mp4', 'dadian')}`,
                        }
                    ],
                    tracks: [
                        { file: "assets/thumbs.vtt", kind: "thumbnails" }, // 缩略图配置文件
                        { file: "assets/sintel-chapters.vtt", kind: "chapters" }, // 视频打点配置文件
                    ]
                }
            ],
            isLive: false,
        },
        dadian2: {
            file: `"${selectPlayUrl(0, 'mp4', 'dadian')}"`,
            title: "'设置打点及缩略图'"
        },
        caption: {
            playlist: [
                {
                    sources: [
                        {
                            file: `${selectPlayUrl(0, 'caption', 'url')}`,
                        }
                    ],
                    tracks: [
                        { file: `${selectPlayUrl(0, 'caption', 'chinese')}`, label: "Chinese" }, // 字幕srt配置文件
                        { file: `${selectPlayUrl(0, 'caption', 'english')}`, label: "English" },
                    ]
                }
            ],
            captions: JSON.stringify({
                back: true, // false表示背景透明，true表示背景黑色
                fontSize: 14, // 字体大小
                fontFamily: "Arial,sans-serif", // 字体样式
                fontOpacity: 100, // 字体透明度
                color: "#FFF", // 字体颜色
                backgroundColor: "#000", // 字幕背景颜色
                backgroundOpacity: 100 // 字幕北京透明度
            }),
            title: "'设置字幕'"
        },
        mystyle: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            title: "'自定义皮肤'",
            autostart: true,
            stretching: '"uniform"',
            volume: 100,
            controls: true,
            controlbar: JSON.stringify({
                barLogo: true, // 进度条上的logo显示与否,默认true
                barLogoUrl: "https://www.baidu.com/", // 进度条上的logo的跳转地址可配置
                canDrag: true, // 进度条是否允许拖动,默认true
            }),
            skin: JSON.stringify({
                name: "bce", // 默认皮肤-bce，其他可选项有beelden, bekle, five, glow, roundster, seven, six, stormtrooper, vapor
                inactive: "#FFF", // 未激活时的颜色
                active: "red", // 悬浮或激活的颜色
            }),
        },
        api: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            title: "'api'"
        },
        apiEvent: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            title: "'apiEvent'"
        },
        liveFlv: {
            file: `"${selectPlayUrl(0, 'flv', 'liveAvc')}"`,
            isLive: true,
            title: "'flv直播'"
        },
        liveHls: {
            file: `"${selectPlayUrl(0, 'hls', 'liveAvc')}"`,
            isLive: true,
            title: "'hls直播'"
        },
        liveRtc: {
            RtcPlugin: JSON.stringify({
                serverUrl: "webrtc://by-test.bj-webrtc-pl001.bigenemy.cn/myapp/test_realtime" //信令请求连接地址
            }),
            isLive: true,
            title: "'RTC'"
        },
        token: {
            file: `"${selectPlayUrl(0, 'hls', 'token')}"`,
            tokenEncrypt: "true",// 说明使用token加密
            title: "'token加密'"
        },
        playbinding: {
            file: `"${selectPlayUrl(0, 'hls', 'playbinding')}"`,
            title: "'playbinding加密'"
        },
        playbackRate: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            playRate: true + ` ,//  默认h5播放器有倍速功能，如不需要，可以设置为false`,
            playRateConfig: JSON.stringify([
                { label: "×1" },
                { label: "×2" },
                { label: "×3" },
                { label: "×4" },
            ]) + `,// 可配置倍速值数组'`,
            title: "'倍速播放'",
        },
        rightclick: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            rightclick: JSON.stringify([ // 右键配置
                {
                    title: "帮助文档", // 标题1
                    link: "https://cloud.baidu.com/doc/MCT/Web-SDK.html#.E6.92.AD.E6.94.BE.E5.99.A8.20Web.20SDK.20.E7.AE.80.E4.BB.8B" // 跳转链接
                },
                {
                    title: "百度VOD产品",
                    link: "https://cloud.baidu.com/product/vod.html"
                },
            ]),
            title: "'自定义右键'",
        },
        adv: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            imageAdvs: JSON.stringify({ // 图片广告，低版本IE不支持
                start: { // 开场广告
                    image: "https://bce.bdstatic.com/portal/img/product/vod/banner_733b26c3.png", // 广告图片地址
                    url: "https://cloud.baidu.com/product/vod.html", // 跳转url
                    time: 10 // 播放时长，单位：s
                },
                pause: { // 暂停广告
                    image: "https://bce.bdstatic.com/portal/img/product/lss/banner_117d201d.png",
                    url: "https://cloud.baidu.com/product/lss.html"
                },
                end: { // 结束广告
                    image: "https://bce.bdstatic.com/portal/img/solution/video_ai/title_1aea461b.png",
                    url: "https://cloud.baidu.com/solution/video_ai.html"
                }
            }),
            title: "'图片广告'"
        },
        adv2: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            imageAdvs: JSON.stringify({
                advs: [
                    {
                        begin: 10, // 广告播放开始时间，单位s
                        end: 20, // 广告播放结束时间
                        material: {
                            landingPage: "https://www.baidu.com",  // 落地页
                            image: "http://staticcdn.videojj.com/FhnEoONICSR2pJ0us4hRaG63u2B9", // 广告图片
                            horizontalPosition: "left",   // 广告展示水平位置　left | right 
                            verticalPosition: "bottom" // 广告展示垂直位置　top  | bottom
                        }
                    },
                    {
                        begin: 25, // 广告播放开始时间，单位s
                        end: 35, // 广告播放结束时间
                        material: {
                            landingPage: "https://cloud.baidu.com",  // 落地页
                            image: "http://images.sohu.com/saf/a2017/0428/ChAKr1kC-ZKAMi7yAABKP28gTgg404160x245.jpg", // 广告图片
                            horizontalPosition: "right",   // 广告展示水平位置　left | right 
                            verticalPosition: "top" // 广告展示垂直位置　top  | bottom
                        }
                    }
                ]
            }),
            title: "'图片广告'"
        },
        marquee: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            marquee: JSON.stringify({ // 跑马灯设置（IE9及以下不支持）
                show: true, // 显示与否
                text: "欢迎使用cyberplayer", // 文案
                fontSize: 20, // 字体大小
                color: "#990033" // 字体颜色
            }),
            title: "'跑马灯'"
        },
        danmaku: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            danmaku: JSON.stringify({
                show: true, // 是否开启弹幕
                fontSize: 24, // 弹幕字体大小
                speed: 1, // 弹幕速度
                area: 0.5, // 弹幕区域 可选值：0.25 | 0.5 | 0.75 | 1
                opacity: 1, // 弹幕透明度
                disabled: false, // 是否禁用弹幕
                items: [{
                    text: '阿萨德',
                    time: '0.006'
                },
                {
                    text: 'asdasdasd',
                    time: '0.006'
                },
                {
                    text: '巫师3',
                    time: '0.006'
                },
                {
                    text: '自己的弹幕',
                    time: '0.006'
                },
                {
                    text: '自己的',
                    time: '0.006'
                },
                {
                    text: '测试自己的弹幕',
                    time: '1.294'
                },
                {
                    text: '洛天依记包子铺。',
                    time: '1.761'
                },
                {
                    text: '自己发的',
                    time: '1.883'
                },
                {
                    text: '鬼畜区没有福利，只有比利',
                    time: '2.894'
                },
                {
                    text: '看到天依滚了进来',
                    time: '3.06'
                },
                {
                    text: '看到封面天依就进了',
                    time: '3.46'
                },
                {
                    text: '见封滚',
                    time: '3.461'
                },
                {
                    text: '看见天依就滚进来了',
                    time: '3.473'
                },
                {
                    text: '百万助攻',
                    time: '3.597'
                },
                {
                    text: '1.5倍速食用更佳',
                    time: '3.706'
                },
                {
                    text: '1.5倍速食用更佳',
                    time: '3.706'
                },
                {
                    text: '1.5倍速食用更佳',
                    time: '4.706'
                },
                {
                    text: '1.5倍速食用更佳',
                    time: '4.706'
                },
                {
                    text: '恭喜发现双声道耳机福利鬼畜',
                    time: '4.745'
                },
                {
                    text: '恭喜发现双声道耳机福利鬼畜',
                    time: '4.745'
                },
                {
                    text: '恭喜发现双声道耳机福利鬼畜',
                    time: '5.745'
                },] // 弹幕列表
            }),
            title: "'弹幕'"
        },
        markdanmaku: {
            file: `"${selectPlayUrl(0, 'mp4', 'danmu')}"`,
            danmaku: JSON.stringify({
                show: true, // 是否开启弹幕
                active: true,
                useMask: true,
                fontSize: 24, // 弹幕字体大小
                speed: 1, // 弹幕速度
                area: 0.5, // 弹幕区域 可选值：0.25 | 0.5 | 0.75 | 1
                opacity: 1, // 弹幕透明度
                disabled: false, // 是否禁用弹幕
                items: [{
                    text: '阿萨德',
                    time: '0.006'
                },
                {
                    text: 'asdasdasd',
                    time: '0.006'
                },
                {
                    text: '巫师3',
                    time: '0.006'
                },
                {
                    text: '自己的弹幕',
                    time: '0.006'
                },
                {
                    text: '自己的',
                    time: '0.006'
                },
                {
                    text: '测试自己的弹幕',
                    time: '1.294'
                },
                {
                    text: '洛天依记包子铺。',
                    time: '1.761'
                },
                {
                    text: '自己发的',
                    time: '1.883'
                },
                {
                    text: '鬼畜区没有福利，只有比利',
                    time: '2.894'
                },
                {
                    text: '看到天依滚了进来',
                    time: '3.06'
                },
                {
                    text: '看到封面天依就进了',
                    time: '3.46'
                },
                {
                    text: '见封滚',
                    time: '3.461'
                },
                {
                    text: '看见天依就滚进来了',
                    time: '3.473'
                },
                {
                    text: '百万助攻',
                    time: '3.597'
                },
                {
                    text: '1.5倍速食用更佳',
                    time: '3.706'
                },
                {
                    text: '1.5倍速食用更佳',
                    time: '3.706'
                },
                {
                    text: '1.5倍速食用更佳',
                    time: '4.706'
                },
                {
                    text: '1.5倍速食用更佳',
                    time: '4.706'
                },
                {
                    text: '恭喜发现双声道耳机福利鬼畜',
                    time: '4.745'
                },
                {
                    text: '恭喜发现双声道耳机福利鬼畜',
                    time: '4.745'
                },
                {
                    text: '恭喜发现双声道耳机福利鬼畜',
                    time: '5.745'
                },] // 弹幕列表
            }),
            title: "'蒙版弹幕'"
        },
        log: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            title: "'日志记录'"
        },
        performanceInfo: {
            file: `"${selectPlayUrl(0, 'flv', 'hevc')}"`,
            liveInfoPanel: JSON.stringify({
                showInfo: true, // 显示与否
            }) + `,// 配置是否显示面板信息，在useSoftDecoding为true的时候生效`,
            useSoftDecoding: true + `,//配置是否使用软解 `,
            title: "'面板信息'"
        },
        normalWatermark: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            watermark: JSON.stringify({   //添加水印参数
                type: 'text', //水印类型：‘text’ or ‘image
                speed: 0.5,// 水印速度，0-1  默认为0可理解为静态
                content: "这里是水印",//水印内容 默认为空
                opacity: 1,//水印透明度 默认为0.5
                fontSize: '12px',//字体大小 默认为12px,特殊说明单位:px
                color: '#fff',//水印颜色 默认为白
                left: '10px',//水印位置 默认为右侧
                bottom: '100px',//水印位置 默认距离下�
                rotate: '0deg',//水印旋转角度 默认为30度,以文本中心为旋转点
                // width:'50px' //设置水印的宽度，单位为px
            }),
            title: "'普通水印'"
        },
        minBufferLength: {
            file: `"${selectPlayUrl(0, 'hls', 'avc')}"`, // hls点播地址
            maxBufferLength: 60, // 通过maxBufferLength配置项来设置最大缓冲秒数
        },
        pictinpict: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            pictinpict: true,
            title: "'画中画'"
        },
        audio: {
            file: `"${selectPlayUrl(0, 'audio', 'mp3')}"`,
            title: "'音频播放'"
        },
        hevc: {
            file: `"${selectPlayUrl(0, 'hls', 'hevc')}"`,
            title: "'h265点播播放'"
        },
        vvc: {
            file: `"${selectPlayUrl(0, 'mp4', 'vvc')}"`,
            useSoftDecoding: true,
            title: "'h266点播播放'"
        },
        av1: {
            file: `"${selectPlayUrl(0, 'mp4', 'av1')}"`,
            title: "'av1硬解播放'"
        },
        av1soft:{
            file: `"${selectPlayUrl(0, 'mp4', 'av1')}"`,
            useSoftDecoding: true,
            title: "'av1软解播放'"
        },
        screenshot: {
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            screenshot: true,
            title: "'截图'"
        },
        record:{
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            title: "'录制'"
        },
        lang:{
            lang:"'en'", 
            showLang:true, 
            playlist: [
                {
                    sources: [
                        {
                            file: `${selectPlayUrl(0, 'quality', 'HD')}`,
                            label: "高清1",
                            definitionTextKey:"HD",
                            default: true // 默认选中
                        },
                        {
                            file: `${selectPlayUrl(0, 'quality', 'SD')}`,
                            label: "标清2",
                            definitionTextKey:"SD",
                        }
                    ],
                    title: "线路1",
                    lineTextKey:"LINENAME_ONE",
                    default: true // 默认选中
                },
                {
                    sources: [
                        {
                            file: `${selectPlayUrl(0, 'quality', 'HD')}`,
                            label: "高清",
                            definitionTextKey:"HD",
                     
                        },
                        {
                            file: `${selectPlayUrl(0, 'quality', 'SD')}`,
                            label: "标清",
                            definitionTextKey:"SD",
                        
                        }
                    ],
                    title: "线路2",
                    lineTextKey:"LINENAME_TWO",
                }
            ],
            danmaku: JSON.stringify({
                show: true, // 是否开启弹幕
                active: true,
                useMask: true,
                fontSize: 24, // 弹幕字体大小
                speed: 1, // 弹幕速度
                area: 0.5, // 弹幕区域 可选值：0.25 | 0.5 | 0.75 | 1
                opacity: 1, // 弹幕透明度
                disabled: false, // 是否禁用弹幕
                items: [{
                    text: '阿萨德',
                    time: '0.006'
                },
                {
                    text: 'asdasdasd',
                    time: '0.006'
                },
                {
                    text: '巫师3',
                    time: '0.006'
                },
                {
                    text: '自己的弹幕',
                    time: '0.006'
                },
                {
                    text: '自己的',
                    time: '0.006'
                },
                {
                    text: '测试自己的弹幕',
                    time: '1.294'
                },
                {
                    text: '洛天依记包子铺。',
                    time: '1.761'
                },
                {
                    text: '自己发的',
                    time: '1.883'
                },
                {
                    text: '鬼畜区没有福利，只有比利',
                    time: '2.894'
                },
                {
                    text: '看到天依滚了进来',
                    time: '3.06'
                },
                {
                    text: '看到封面天依就进了',
                    time: '3.46'
                },
                {
                    text: '见封滚',
                    time: '3.461'
                },
                {
                    text: '看见天依就滚进来了',
                    time: '3.473'
                },
                {
                    text: '百万助攻',
                    time: '3.597'
                },
                {
                    text: '1.5倍速食用更佳',
                    time: '3.706'
                },
                {
                    text: '1.5倍速食用更佳',
                    time: '3.706'
                },
                {
                    text: '1.5倍速食用更佳',
                    time: '4.706'
                },
                {
                    text: '1.5倍速食用更佳',
                    time: '4.706'
                },
                {
                    text: '恭喜发现双声道耳机福利鬼畜',
                    time: '4.745'
                },
                {
                    text: '恭喜发现双声道耳机福利鬼畜',
                    time: '4.745'
                },
                {
                    text: '恭喜发现双声道耳机福利鬼畜',
                    time: '5.745'
                },] // 弹幕列表
            }),
            languages: JSON.stringify({
                en:{
                  LINENAME_ONE:'Line 1',
                  LINENAME_TWO:'Line 2',
                  SD:'SD',
                  HD:'HD',
                  PLAYLIST_TITLE:'play list', //播放列表title文案
                  en:'english',
                  zh:'chinese'
                },
                zh: {
                    LINENAME_ONE: '线路一',
                    LINENAME_TWO: '线路二',
                    SD: '标清',
                    HD: '高清',
                    PLAYLIST_TITLE: '播放列表', //播放列表title文案
                    en: '英文',
                    zh: '中文'
                }
            }),
            title: "'多语言'"
        },
        liveShift:{
            file:`"${selectPlayUrl(0,'hls', 'shift')}"`,
            timeShift:JSON.stringify({
                liveStartTime:Date.now() / 1000 - 60,  //则表示观众可以看 1 分钟前的直播回放
            }),
            isLive:true,
            title: "'直播hls时移'"
        },
        autoHeaders:{
            file: `"${selectPlayUrl(0, 'flv', 'avc')}"`,
            headers:JSON.stringify({
                authtoken:"XXXXXX",
            }),
            title: "'自定义headers'", 
        },
        memoryplay:{
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            isMemoryPlay:true,
            title: "'记忆播放'", 
        },
        starttime:{
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            starttime:10,
            title: "'从指定位置播放'", 
        },
        rotate:{
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            rotate: JSON.stringify({clockwise:false,innerRotate:true}),
            title: "'视频旋转'", 
        },
        mirror:{
            file: `"${selectPlayUrl(0, 'mp4', 'avc')}"`,
            isMirror:true, //设置是否开启镜像
            title: "'视频镜像'", 
        },
        audioTrackChange:{
            file: `"${selectPlayUrl(0, 'dash', 'multiAudio')}"`,
            title: "'多音轨切换'", 
        },
        decoderDegrade:{
            file: `"${selectPlayUrl(0, 'hls', 'hevc')}"`,
            enableDecoderDegrade:false,
            title: "'解码降级'", 
        },
        autoH265:{
            playlist: [
                {
                    sources: [
                        {
                            file: `${selectPlayUrl(0, 'autoH265', 'hevc')}`,
                            label: "h265"
                        },
                        {
                            file: `${selectPlayUrl(0, 'autoH265', 'avc')}`,
                            label: "h264"
                        }
                    ],
                    title: "线路1"
                }
            ],
            enableDecoderDegrade: false,
            isLive: false,
            title: "'自动h265'",
        }

    };
    return fileConfig[type];
}
function getPlayerfun(type) {
    let func = {
        api: `
          /*
            API包括：
            1、基本动作
            加载视频：player.load({file: "http://gcqq450f71eywn6bv7u.exp.bcevod.com/mda-hbqagik5sfq1jsai/mda-hbqagik5sfq1jsai.mp4"});
            播放视频：player.play();
            暂停视频：player.pause();
            停止视频：player.stop();
            跳转视频：player.seek(10); // 参数：第几秒
            修改屏幕大小：player.resize(600, 400); // 参数1：宽度，参数2：高度
            播放下一个视频：var item = myPlayer.playlistNext(); // 仅当配置了playlist时生效，并可得到下一个视频
            播放上一个视频：var item = myPlayer.playlistPrev(); // 仅当配置了playlist时生效，并可得到上一个视频
            注销播放器: player.remove();
            播放指定的播放条目，并返回该对象，从0计数: var item = myPlayer.playlistItem(2);
       

            2、getter
            获取当前播放视频的总时长：var duration = player.getDuration();
            获取当前时候是全屏状态：var isFullscreen = player.getFullscreen();
            获取当前播放器展现宽度：var width = player.getWidth();
            获取当前播放器展现高度：var height = player.getHeight();
            获取当前播放视频的元数据(包括时长和视频宽高)：var meta = player.getMeta();
            获取当前是否处于静音状态：var isMute = player.getMute();
            获取当前播放倍速：var playbackRate = player.getPlaybackRate();
            获取当前播放倍速：var playbackRate = player.getPlaybackRate();
            获取当前播放列表: var playlist = player.getPlaylist();
            获取当前播放视频在playlist中的索引：var playlistIndex = player.getPlaylistIndex();
            获取当前播放的视频对象：var playlistItem = player.getPlaylistItem();
            获取当前播放的视频的播放位置：var position = player.getPosition();
            获取当前播放器类别（html5 or videojs or flash）：var provider = player.getProvider();
            获取当前视频的所有码率: var qualityLevels = myPlayer.getQualityLevels();
            获取当前播放器状态({"playing"、"paused"、"idle"、"buffering"}): var state = myPlayer.getState();
            获取当前播放的音量：var volume = player.getVolume();
            获取视频缓冲比率,0-100: var buffer = player.getBuffer();
            获取当前的所有配置项: var config = player.getConfig();
            获取当前播放容器对象: var container = player.getContainer();
            获取当前是否能存在controls: var isControl = player.getControls();
            获取当前正在播放视频的码率索引，从0开始: var currentQuality = myPlayer.getCurrentQuality();
        
            2、setter
            设置播放器是否显示controlbar：player.setControls(false);
            设置打点数据：player.setCues([
                    {begin: 9.5, end: 10.5, text: "我的信息1"},
                {begin: 19.5, end: 20.5, text: "我的信息2"}
            ]); // 详见“设置打点或缩略图”
            设置播放某种码率的视频: myPlayer.setCurrentQuality(1);
            设置当前播放器是否全屏: player.setFullscreen(true);
            设置当前播放器是否静音：player.setMute(true);
            设置当前播放器播放速率：player.setPlaybackRate(2);
            设置打点缩略图(要结合setCues使用)：player.setThumbnails(); // 详见“设置打点或缩略图”
            设置Token: player.setToken(); // 使用方法详见“播放token加密视频”
            设置当前播放器音量：player.setVolume(100);
        */
         `,
        apiEvent: `/*
            事件回调包括：
            onBeforeComplete: 结束播放之前的监听函数
            onBeforePlay: 开始播放之前的监听函数
            onBuffer: 开始缓冲的监听函数
            onBufferChange: 缓冲区变化的监听函数（缓冲了更多视频时激活），可以获得到现在缓冲百分比
            onBufferFull: 缓冲区满了之后监听函数
            onCaptionsChange: 字幕改变后的监听函数
            onCaptionsList: 字幕加载成功的监听函数
            onComplete: 视频播放完成后的监听函数
            onDisplayClick: 用户点击播放区域后的监听函数
            onError: 播放器出错的监听函数
            onFullscreen: 全屏的监听函数
            onIdle: 状态变成空闲（idle）后的监听函数
            onMute: 静音事件监听函数
            onPause: 暂停事件监听函数
            onPlay: 播放事件监听函数
            onPlaylist: 播放器播放列表接收函数
            onPlaylistItem: 播放器当前播放条目变化监听函数
            onQualityChange: 播放码率变化的监听函数
            onQualityLevels: 视频码率的接收函数
            onReady: 播放器初始化完成后的监听函数
            onResize: 播放器大小改变后的监听函数
            onSeek: 视频拖动后的监听函数
            onSetupError: 播放器加载失败后的监听函数
            onStop: 视频停止播放的监听函数
            onTime: 视频播放时间点实时变换的监听函数
            onVolume: 音量改变后的监听函数
            onAlive: 监听直播流的状态，有直播流时触发
            onNoLiveStream: 监听直播流的状态，无直播流时触发
            示例：
            player.onTime = ()=>{
                console.log("当前播放的时间点是：" + player.getCurrentTime());
            }
             */`,
        token: `player.on("beforePlay", function (e) {
            // 这里模拟从后端获得token的操作，实际的token应该是后端来获取并传给前端的
                 player.setToken(e.file, "9f053a2ec94fff0dc4cc15048f007405d1392abf0accfd5bb699dd3af1e27824_74c1802568074d7bbb02174ca9b81d53_1898234043");
           });
           `,
        log: `/*
            播放器自动会在如下事件发生后记录日志:
            meta: 视频元数据获得后
            beforePlay: 视频播放之前
            play: 视频开始播放时
            seek: 视频跳转后
            pause: 视频暂停后
            idle: 播放空闲时
            stop: 视频停止后
            error: 视频停止后
            setupError: 播放器加载出错时
            alive: 直播有流时
            liveStop: 直播结束后
            noLiveStream: 直播无流时

            有了这些统计数据后可以得到某个视频的播放详细信息，
            例如某视频在什么时候停止播放的，
            一般拖动到第几秒开始播放，直播卡顿等情况。
            */`,
        dadian2: `player.onReady(function () {
            // 动态设置打点
                player.setCues([
                    { begin: 0.5, end: 1.5, text: '我的信息1' },
                    { begin: 2.5, end: 3, text: '我的信息 策优化调整后的首个假期，拉动中国经济最重要的“三驾马车”之一——消费正在' },
                    { begin: 9.5, end: 10.5, text: '相关部门的数据是更有力的说明——元旦假期全国铁路日均发送旅客较去年11月份增长109%；国内旅游收入265.17亿元，同比增长4.0%；新年首日，全国营业影院数量创下近10个月以来的新高；“2023全国网上年货节”首日，全国网络零售额452亿元，比去年年货节首日增长了6.5%……在疫情防控政策优化调整后的首个假期，拉动中国经济最重要的“三驾马车”之一——消费正在回暖，传递出中国经济向上向好的积极信号。   最艰难的时刻，我们已经挺过。回首疫情以来的三年，我国经受了新冠疫情冲击、世界变局加快演变等多重考验，一直是全球经济发展的重要动力源。2020年我国成为全球率先实现经济正增长的主要经济体；2021年我国经济承压前行，同比增长8.1%，实现“十四五”良好开局；2022年我国继续保持世界第二大经济体的地位，经济稳健发展，全年国内生产总值预计超过120万亿元。正如习近平主席在新年贺词中所强调的：“中国经济韧性强、潜力大、活力足，长期向好的基本面依然不变。只要笃定信心、稳中求进，就一定能实现我们的既定目标。”' },
                    { begin: 19.5, end: 20.5, text: '我的信息2 策优化调整后的首个假期，拉动中国经济最重要的“三驾马车”之一——消费正在回暖，传递出中国经济向上向好的积极信号' },
                    { begin: 29.5, end: 30.5, text: '策优化调整后的首个假期，拉动中国经济最重要的“三驾马车”之一——消费正在回暖，传递出中国经济向上向好的积极信号。   最艰难的时刻，我们已经挺过。回首疫情以来的三年，我国经受了新冠疫情冲击、世界变局加快演变等多重考验，一直是全球经济发展的重要动力源。2020年我国成为全球率先实现经济正增长的主要经济体；2021年我国经济承压前行，同比增长8.1%，实现“十四五”良好开局；2022年我国继续保持世界第二大经济体的地位，经济稳健发展，全年国内生产总值预计超过120万亿元。正如习近平主席在新年贺词中所强调的：“中国经济韧性强、潜力大、活力足，长期向好的基本面依然不变。只要笃定信心、稳中求进，就一定能实现我们的既定目标。”' },
                ]);
                设置缩略图
                player.setThumbnails([
                    { begin: 0.5, end: 1.5, text: 'http://cyberplayer.bcelive.com/thumbnail.jpg' },
                    { begin: 19.5, end: 20.5, text: 'http://cyberplayer.bcelive.com/thumbnail.jpg' },
                ]);
            })`,
        screenshot: `
        player.onScreenshot((info)=>{
            var a = document.createElement('a'); 
            var event = new MouseEvent('click');
            a.download = 'screenshot';
            var dataURI = info.src
            var binStr = atob(dataURI.split(',')[1]),
                len = binStr.length,
                arr = new Uint8Array(len);

            for (var i = 0; i < len; i++) {
                arr[i] = binStr.charCodeAt(i);
            }
            var blobs = new Blob([arr],{type:'image/png'});
            try {
                if(navigator.userAgent.includes('113')){
                  return  window.open(URL.createObjectURL(blobs));
                }
                 a.href = URL.createObjectURL(blobs);

            } catch (e) {
            }

            a.dispatchEvent(event) 
        })
        `,
        record:`
           var recordIcon = document.createElement("div");

           var recordBtn = '<button><svg t="1695385858371" class="icon" width=15 height=15 viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="6846" width="200" height="200"><path d="M647.725 840.897s93.091 0 93.091-93.091V282.353c0-93.091-93.091-93.091-93.091-93.091H93.091S0 189.262 0 282.353v465.453c0 93.091 93.091 93.091 93.091 93.091h554.634z m147.316-469.782V660.72l228.956 180.177V189.263L795.041 371.115z" p-id="6847" fill="#8a8a8a"></path></svg></button>';
           var recordingBtn = '<button><svg t="1695385858371" class="icon" width=15 height=15 viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="6846" width="200" height="200"><path d="M647.725 840.897s93.091 0 93.091-93.091V282.353c0-93.091-93.091-93.091-93.091-93.091H93.091S0 189.262 0 282.353v465.453c0 93.091 93.091 93.091 93.091 93.091h554.634z m147.316-469.782V660.72l228.956 180.177V189.263L795.041 371.115z" p-id="6847" fill="#d81e06"></path></svg></button>';
           recordIcon.innerHTML = recordBtn;
           recordIcon.id = 'recordBtn';
           recordIcon.setAttribute('data-type','record');
           document.body.appendChild(recordIcon);
           recordIcon.addEventListener('click',(e)=>{
            let dataType = recordIcon.getAttribute('data-type');
            dataType == 'record' ? player.setCaptureFrameStart() : player.setCaptureFrameEnd();
            dataType == 'record' ?  recordIcon.innerHTML = recordingBtn : recordIcon.innerHTML = recordBtn;
            recordIcon.setAttribute('data-type', dataType == 'record'?'recording':'record');
           });
           player.onCaptureFrameFinished((info)=>{
               if(info.blobSize == 0 || info.code != 0){
                 alert('录制失败，浏览器不兼容')
               }else{
               var a = document.createElement('a'); 
               var event = new MouseEvent('click');
               a.download = 'record';
               a.href = info.recorder_video_url;
               a.dispatchEvent(event) 
            }
           })

        `,
        liveFlv:`
        //通过监听error事件获取错误日志。
        player.on('error',(data)=>{
           console.log(data);
        })
        `,
        adaptive:`
         //自适应码流
         player.on('hls_level_updated',(data)=>{
            console.log(data,'hls_level_updated');
            console.log(player.getHlsCurrentLevel(),'hls_level_updated')
         })
        `
    }
    if (func[type]) {
        return func[type]
    } else {
        return ''
    }
}
addClickCallback((type) => {
    var html = getHtml(type);
    htmlEditor.setValue(html);
    document.querySelector("#preview-window").contentWindow.player.remove();
    if(window.recordIcon){
        window.recordIcon = null;
    }
    setIframe();
});
var htmlEditor = CodeMirror(
    document.querySelector(".editor .code .html-code"),
    {
        mode: "htmlmixed",
        tabSize: 4,
        lineNumbers: true,
        extraKeys: { "Ctrl-Space": "autocomplete" },
    }
);
CodeMirror.commands["selectAll"](htmlEditor);
// vr
var html = getHtml('vr');
htmlEditor.setValue(html)
setIframe();
document.querySelector("#run-btn").addEventListener("click", function () {
    document.querySelector("#preview-window").contentWindow.player.remove();
    setIframe()
});
function setIframe() {
    let htmlCode = htmlEditor.getValue();
    let previewWindow =
        document.querySelector("#preview-window").contentWindow.document;
    previewWindow.open();
    previewWindow.write(htmlCode);
    previewWindow.close();
    let isIframeLoad = false
    if(this.isIosWeChat()){
        let iframe = document.querySelector("#preview-window");
        document.addEventListener("WeixinJSBridgeReady", function () {
            isWeixinJSBridgeReady = true;
            if(isIframeLoad){
                iframe.contentWindow.postMessage({event:'WeixinJSBridgeReady',handler:'WeixinJSBridgeReady'}, '*');
            }
        })
        iframe.onload = function () { 
            isIframeLoad = true;
            if(isWeixinJSBridgeReady){
                iframe.contentWindow.postMessage({event:'WeixinJSBridgeReady',handler:'iframeOnload'}, '*');
            }
        }
    }
}
document.querySelector("#copy").addEventListener("click", function () {
    copyText(htmlEditor.getValue())
});
//复制文本
function copyText(text) {
    var element = createElement(text);
    element.select();
    element.setSelectionRange(0, element.value.length);
    document.execCommand('copy');
    element.remove();
    alert("已复制到剪切板");
}

//创建临时的输入框元素
function createElement(text) {
    var isRTL = document.documentElement.getAttribute('dir') === 'rtl';
    var element = document.createElement('textarea');
    // 防止在ios中产生缩放效果
    element.style.fontSize = '12pt';
    // 重置盒模型
    element.style.border = '0';
    element.style.padding = '0';
    element.style.margin = '0';
    // 将元素移到屏幕外
    element.style.position = 'absolute';
    element.style[isRTL ? 'right' : 'left'] = '-9999px';
    // 移动元素到页面底部
    let yPosition = window.pageYOffset || document.documentElement.scrollTop;
    element.style.top = `${yPosition}px`;
    //设置元素只读
    element.setAttribute('readonly', '');
    element.value = text;
    document.body.appendChild(element);
    return element;
}
// 判断是否是ios微信
function isIosWeChat(){
   let ua = navigator.userAgent;
   if(ua){
      ua = ua.toLocaleLowerCase();
      return ua.includes('micromessenger') && (ua.includes('iphone') || ua.includes('ipad') || ua.includes('ipod'));
   }else{
      return false; 
   }
}
// 播放链接
function selectPlayUrl(type, style, codecStyle) { 
    const testUrl = {
        mp4: {
            avc: 'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/smart_danmu/h264-add-sei-svg-sample-overall.mp4',
            av1:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/av1/1080p/liulangdiqiu-av1-1080-faststart.mp4',
            hevc: 'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/265/1080p/no_subtext.mp4',
            vvc:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/vvc/1080p/liulangdiqiu-266-1080.mp4',
            dadian: 'http://content.bitsontherun.com/videos/3XnJSIm4-52qL9xLP.mp4',
            danmu:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/smart_danmu/h264-add-sei-svg-sample-overall.mp4',
            vr:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/360video/ThaiKongfu.mp4'
        },
        ts: {
            avc: 'http://bdcloud-player-new.cdn.bcebos.com/testvideo/ts/264/ts_loading_slow.ts',
            hevc: 'https://bdcloud-player-new.cdn.bcebos.com/testvideo/ts/AV1/liulangdiqiu-av1-1080.ts'
        },
        flv: {
            avc: 'https://bdcloud-player-new.bj.bcebos.com/testvideo/flv/264/1080p/liulangdiqiu-264-1080.flv',
            hevc: 'https://bdcloud-player-new.cdn.bcebos.com/testvideo/flv/265/1080p/liulangdiqiu-265.flv',
            liveAvc: 'https://live.nodemedia.cn:8443/live/b480_264.flv',
            liveHevc: 'https://live.nodemedia.cn:8443/live/tcl_265.flv'
        }, 
        hls: {
            avc: 'http://cyberplayer.bcelive.com/videoworks/mda-kbuhu4wqdi08dwix/cyberplayer/hlsa/cyberplayer-demo.m3u8',
            hevc: 'https://bdcloud-player-new.cdn.bcebos.com/testvideo/hls/265/1080p/liulangdiqiu/liulangdiqiu-265-1080.m3u8',
            liveAvc: 'http://smartvideo-live-hls.a.bdydns.com/testabc/123.m3u8',
            liveHevc: 'https://live.nodemedia.cn:8443/live/tcl_265.flv',
            shift:'http://live-bd.wisetv.com.cn/TJIPTV/TJWSHD.m3u8',
            token: 'http://bj.bcebos.com/v1/bdcloud-player/bdcloud-player/testvideo/hls/264/trump.m3u8'
        },
        quality: {
            SD: "https://bdcloud-player-new.bj.bcebos.com/testvideo/hls/264/720p/bdcloud/bdcloud.m3u8",
            HD: "https://bdcloud-player-new.bj.bcebos.com/testvideo/hls/264/720p/bdcloud/bdcloud.m3u8"
        },
        audio: {
            mp3: "https://bdcloud-player-new.bj.bcebos.com/testaudio/mp3/Hotel%20California-The%20Eagles.mp3"
        },
        caption: {
            url: "http://cyberplayer.bcelive.com/videoworks/mda-kbuhu4wqdi08dwix/cyberplayer/mp4/cyberplayer-demo.mp4",
            chinese: "//playertest.longtailvideo.com/captions/sintel-ch.srt",
            english: "//playertest.longtailvideo.com/captions/sintel-fa.srt"
        },
        dash: {
            avc: "https://1a-mixer.bj.bcebos.com/1a-mixer/dash/mcp_video_dash_1080.mpd",
            hevc:"https://1a-mixer/1a-mixer/dash/mcp_video_265_dash.mpd",
            av1:"https://storage.googleapis.com/bitmovin-demos/av1/stream_chrome.mpd",
            multiAudio:"https://media.axprod.net/TestVectors/v7-Clear/Manifest_1080p.mpd",
        },
        autoH265:{
            avc:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/264/720p/bdcloud.mp4',
            hevc:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/265/720p/bdcloud.mp4.mp4'
        }
    };
    const onlineUrl = {
        mp4: {
            avc: 'http://cyberplayer.bcelive.com/videoworks/mda-kbuhu4wqdi08dwix/cyberplayer/mp4/cyberplayer-demo.mp4',
            hevc: 'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/265/1080p/no_subtext.mp4',
            av1:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/av1/1080p/liulangdiqiu-av1-1080-faststart.mp4',
            vvc:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/vvc/1080p/liulangdiqiu-266-1080.mp4',
            dadian: 'http://content.bitsontherun.com/videos/3XnJSIm4-52qL9xLP.mp4',
            danmu:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/smart_danmu/h264-add-sei-svg-sample-overall.mp4',
            vr:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/360video/ThaiKongfu.mp4'
        },
        ts: {  //目前没有显示的地方
            avc: 'http://bdcloud-player-new.cdn.bcebos.com/testvideo/ts/264/ts_loading_slow.ts',
            hevc: 'https://bdcloud-player-new.cdn.bcebos.com/testvideo/ts/AV1/liulangdiqiu-av1-1080.ts'
        },
        flv: {
            avc: 'http://cyberplayer.bcelive.com/videoworks/mda-kbuhu4wqdi08dwix/cyberplayer/flv/cyberplayer-demo.flv',
            hevc: 'https://bdcloud-player-new.cdn.bcebos.com/testvideo/flv/265/1080p/liulangdiqiu-265.flv',
            liveAvc: 'http://smartvideo-live-flv.a.bdydns.com/testabc/123.flv',
            liveHevc: 'http://smartvideo-live-flv.a.bdydns.com/testabc/123.flv'
        },
        hls: {
            avc: 'http://cyberplayer.bcelive.com/videoworks/mda-kbuhu4wqdi08dwix/cyberplayer/hlsa/cyberplayer-demo.m3u8',
            hevc: 'https://bdcloud-player-new.cdn.bcebos.com/testvideo/hls/265/1080p/liulangdiqiu/liulangdiqiu-265-1080.m3u8',
            shift:'http://live-bd.wisetv.com.cn/TJIPTV/TJWSHD.m3u8',
            liveAvc: 'http://smartvideo-live-hls.a.bdydns.com/testabc/123.m3u8',
            token: 'http://bj.bcebos.com/v1/bdcloud-player-new/bdcloud-player/testvideo/hls/264/trump.m3u8',
            playbinding:'https://bdcloud-player-new.cdn.bcebos.com/demovideo/binding/trump.m3u8'
        },
        quality: {
            SD: 'http://cyberplayer.bcelive.com/videoworks/mda-kbuhu4wqdi08dwix/cyberplayer/hlsa/cyberplayer-demo_426x240_494000.m3u8',
            HD: 'http://cyberplayer.bcelive.com/videoworks/mda-kbuhu4wqdi08dwix/cyberplayer/hlsa/cyberplayer-demo_640x360_890000.m3u8'
        },
        audio: {
            mp3: "https://bdcloud-player-new.cdn.bcebos.com/testaudio/mp3/Hotel%20California-The%20Eagles.mp3"
        },
        caption: {
            url: "http://cyberplayer.bcelive.com/videoworks/mda-kbuhu4wqdi08dwix/cyberplayer/mp4/cyberplayer-demo.mp4",
            chinese: "//playertest.longtailvideo.com/captions/sintel-ch.srt",
            english: "//playertest.longtailvideo.com/captions/sintel-fa.srt"
        },
        dash: {
            avc:"https://dash.akamaized.net/akamai/bbb_30fps/bbb_30fps.mpd",
            // avc: "https://1a-mixer.bj.bcebos.com/1a-mixer/dash/mcp_video_dash_1080.mpd",
            hevc:"https://1a-mixer/1a-mixer/dash/mcp_video_265_dash.mpd",
            av1:"https://storage.googleapis.com/bitmovin-demos/av1/stream_chrome.mpd",
            multiAudio:"https://media.axprod.net/TestVectors/v7-Clear/Manifest_1080p.mpd",
        },
        autoH265:{
            // avc:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/hls/264/720p/bdcloud/bdcloud.m3u8',
            // hevc:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/hls/265/1080p/liulangdiqiu/liulangdiqiu-265-1080.m3u8'
            // avc:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/flv/264/1080p/liulangdiqiu-264-1080.flv',
            // hevc:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/flv/265/1080p/liulangdiqiu-265.flv'
            avc:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/264/720p/bdcloud.mp4',
            hevc:'https://bdcloud-player-new.cdn.bcebos.com/testvideo/mp4/265/720p/bdcloud.mp4.mp4'
        }
    };
    const url = { 1: testUrl, 0: onlineUrl };
    return url[type][style][codecStyle]
}